# Resilver

## Usage

- Run (only) "Rxcle.Resilver.Installer.exe"
  - The executable is not signed
  - If windows will not start it, click click "Properties" and "Unblock"
  - In Windows Defender/Smartscreen ignore any warnings and Run anyway.
- Check that the "Silverlight Installer" is set
- Check that the "Startup Application URL" is set
- Leave Resilver Licence Key empty for TRIAL installation.
- Click "Install" button and wait for installation to complete.

Shortcuts are created in the Star menu and on the Desktop.

To uninstall:
- Run "Rxcle.Resilver.Installer.exe"
- Click Uninstall

## Configuration

The Resilver Installer (Rxcle.Installer.exe) is a self contained executable that allows the user to install, reinstall, upgrade and uninstall Resilver.
In its basic form as provided by Rxcle, the following information must be provided by the user:

- Silverlight 5 Installer executable file location
- Startup application URL (optional, but strongly recommended)
- License key

During installation 2 shortcuts are created with the default Resilver icon and name: one on the Desktop and one in the Start menu.

For distributing Resilver within your organization or to your customers you might want to customize and/or preconfigure these things.

In order to preconfigure the installer, create a directory called `Include` as a subdirectory of the directory where `Rxcle.Installer.exe` is located. All customization happens in this directory, which means that you only have to ensure to distribute this directory along with the main installer. Typical redistribution scenarios are: putting the installer and directory on a network share or zipping the installer along with the Include directory into a single archive file.

To distribute the Microsoft Silverlight 5 installer along with Resilver so the user doesn't have to provide this for himself, simply place it (`Silverlight_x64.exe`) into the `Include` directory.
No further configuration is needed. When the Resilver Installer starts it will automatically detect the installer.

You can supply a custom icon for the shortcuts that are created on the Desktop and Start menu in Windows. Simply place an ICO file called `shortcut.ico` in the `Include` directory. The name of the shortcut will always be either `Resilver` or the custom name supplied for the `ApplicationName` in the `settings.xml` file.

For other configurations, create a file called `settings.xml` in the `Include` directory.

```xml
<?xml version="1.0" encoding="utf-8"?>
<ResilverInstallerSettings>
  <ApplicationUrl>https://www.test.com</ApplicationUrl>
  <SilverlightInstallerSource>\\mynetwork\shares\Silverlight_x64.exe</SilverlightInstallerSource>
  <!-- other settings -->
</ResilverInstallerSettings>
```

- `ApplicationUrl`
  - The full URL to the web application to load when Resilver is started. Leave empty to let the user decide. The user is allowed to provide no URL here, in which case Resilver starts with a blank page.
- `SilverlightInstallerSource`
  - Full (absolute) file path to the Silverlight installer. Use this if you do not want to distribute the Silverlight installer along with Resilver but instead the Silverlight installer is located on a shared (e.g. network) location.
- `SilverlightInstallerDownloadUrl`
  - URL on which the Silverlight installer can be downloaded. You can supply multiple URLs, separated by a semicolon.
- `LicenseKey` 
  - The license key to use. Note that redistribution is not allowed with Personal license so this will typically be an Enterprise or Redistribution license key.
- `AllowUserOverrides`
  - When set to `false` all settings are assumed to be specified in the `settings.xml` file and will be hidden from user in the installer and thus cannot be overridden. The default for this setting is `true`, meaning that users can always choose their own values or override any default specified.
- `ApplicationName` 
  -  The custom name to use instead of "Resilver". This name is used in the Installer, in the install location and for the Shortcuts. It is recommended to keep this name short and it may not contain characters that are invalid in file names. By using different ApplicationNames you create completely separate "instances" of Resilver.

## Copyright

Rxcle Resilver (hereafter referred to as "the software") is Copyright (c) 2024 Rxcle. All rights reserved.

Installation and usage of the software is permitted only with a valid license for obtained from Rxcle. License are bound to specific versions of the software, only a matching version for a particular version is considered valid.

Redistribution of the software is only valid with a specific license that explicitly permits redistribution. Redistribution without a valid license to do so is not permitted.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Rxcle Resilver makes use of Microsoft Silverlight, which is Copyright Microsoft. Microsoft Silverlight has its own license agreement and redistribution rules which are not covered by this document. A license to install, use or redistribute Rxcle Resilver DOES NOT imply any permission to do so with Microsoft Silverlight. Please read and adhere to Microsoft Silverlight's own License Agreement.

Rxcle Resilver makes use of Waterfox, which is trademarked by Waterfox Ltd. Waterfox is free and open software that is made available under the terms of the Mozilla Public License (MPL) Version 2.0. This License Agreement and any software licenses obtained for Rxcle Resilver ONLY apply to the Rxcle Resilver specific software parts, not to Waterfox.